const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_batches', {
    RecNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    Batch: {
      type: DataTypes.STRING(100),
      allowNull: false,
      defaultValue: "NULL"
    },
    Status: {
      type: DataTypes.STRING(1),
      allowNull: true,
      defaultValue: "N"
    },
    dt: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    tm: {
      type: DataTypes.TIME,
      allowNull: true
    },
    CubicNo: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    cubicleType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Prod_ID: {
      type: DataTypes.STRING(25),
      allowNull: true,
      defaultValue: "NULL"
    },
    Prod_Name: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL"
    },
    Prod_Version: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NA"
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NA"
    },
    batchStatusInCubicle: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    BatchStartDTTM: {
      type: DataTypes.DATE,
      allowNull: true,
      // defaultValue: "0000-00-00",
      comment: "For veersandra summary"
    },
    BatchEndDTTM: {
      type: DataTypes.DATE,
      allowNull: true,
      // defaultValue: "00:00:00",
      comment: "For veersandra summary"
    },
    dt1: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    tm1: {
      type: DataTypes.TIME,
      allowNull: true
    },
    grpflag: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    
  }, {
    sequelize,
    tableName: 'tbl_batches',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "RecNo" },
        ]
      },
    ]
  });
};
